using System;

namespace Klasy
{
	class Ulamek_Exception : Exception
	{
		private String message;
		public Ulamek_Exception(String amessage) {message=amessage;}
		public String what() {return message;}
	}

	public class Ulamek
	{
		private int licznik,mianownik;

		public static readonly Ulamek Zero=new Ulamek(0,1);
		public static readonly Ulamek Jeden=new Ulamek(1,1);
		public static readonly Ulamek Polowa=new Ulamek(1,2);
		public static readonly Ulamek Cwierc=new Ulamek(1,4);

		public Ulamek(int alicznik,int amianownik)
			{
			set(alicznik,amianownik);
			}

		//cos podobnego do konstruktora copy w C++
		public Ulamek(Ulamek aulamek)
			{
			int olicznik,omianownik;
			aulamek.get(out olicznik,out omianownik);
			set(olicznik,omianownik);
			}

		public Ulamek Clone()
			{
			return new Ulamek(licznik,mianownik);
			}

		public void set(int alicznik,int amianownik)
			{
			//if (amianownik==0) return false;
			if (amianownik==0) throw new Ulamek_Exception("Ulamek: Blad #1");
			licznik=alicznik;
			mianownik=amianownik;
			}

		//public void get(ref int rlicznik,ref int rmianownik) //w ref wartosc zmiennej nie musi byc zmieniona
		public void get(out int rlicznik,out int rmianownik) //w out wartosc zmiennej musi byc zmieniona
			{
			rlicznik=licznik;
			rmianownik=mianownik;
			}		

		public void get(int[] arg)
			{
			arg[0]=licznik;
			arg[1]=mianownik;
			}

		public int[] get()
			{
			int[] wynik=new int[2];
			wynik[0]=licznik;
			wynik[1]=mianownik;
			return wynik;
			}

			//Operatory mozna definiowac tylko wewnatrz klasy
		public static Ulamek operator *(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return new Ulamek(alicznik1*alicznik2,amianownik1*amianownik2);
			}

		public static Ulamek operator /(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return new Ulamek(alicznik1*amianownik2,amianownik1*alicznik2);
			}

		public static Ulamek operator +(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return new Ulamek(alicznik1*amianownik2+alicznik2*amianownik1,amianownik1*amianownik2);
			}

		public static Ulamek operator -(Ulamek aulamek1)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			return new Ulamek(-alicznik1,amianownik1);
			}

		public static Ulamek operator -(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return new Ulamek(alicznik1*amianownik2-alicznik2*amianownik1,amianownik1*amianownik2);
			}

		//Nie mozna zdefiniowac < bez >
		public static bool operator <(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return (alicznik1/(double)amianownik1)<(alicznik2/(double)amianownik2);
			}

		public static bool operator >(Ulamek aulamek1,Ulamek aulamek2)
			{
			int alicznik1,amianownik1;aulamek1.get(out alicznik1,out amianownik1);
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return (alicznik1/(double)amianownik1)>(alicznik2/(double)amianownik2);
			}

		//Na implementacje Equals narzucone sa warunki spelniania nastepujacych relacji:
		//zwrotnosc, symetria, przyrownanie do null daje false i inne
		public override bool Equals(object obj)
			{
			if (obj==null) return false;
			Ulamek aulamek2=(Ulamek)obj;
			int alicznik2,amianownik2;aulamek2.get(out alicznik2,out amianownik2);
			return (licznik/(double)mianownik)==(alicznik2/(double)amianownik2);
			}

		//korzystam z XOR(licznik,mianownik)
		public override int GetHashCode()
			{
			return licznik^mianownik;
			}


		//Nie mozna zdefiniowac == bez !=
		//Na wzor Javy mozna zrezygnowac z tych operatorow
		//(pozostawic je do sprawdzania, czy wskazniki odnosza sie do tych samych obiektow),
		//i zadowolic sie metoda Equals
		public static bool operator ==(Ulamek aulamek1,Ulamek aulamek2)
			{
			return aulamek1.Equals((Object)aulamek2);
			}

		public static bool operator !=(Ulamek aulamek1,Ulamek aulamek2)
			{
			return !(aulamek1.Equals((Object)aulamek2));
			}

		//Jak w Javie sluzy takze do automatycznej konwersji
		//nie trzeba juz nic wiecej
		public override string ToString()
			{
			return ""+licznik+"/"+mianownik;
			}

		public double ToDouble()
			{
			return licznik/(double)mianownik;
			}

		//konwersja z Ulamek na double
		public static implicit operator double(Ulamek aulamek)
			{
			return aulamek.ToDouble();
			}

		//konwersja z int na Ulamek
		public static implicit operator Ulamek(int aliczba_calkowita)
			{
			return new Ulamek(aliczba_calkowita,1);
			}
	}
}
